% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_lightgbm.R
\name{cv_lightgbm}
\alias{cv_lightgbm}
\title{lightgbm - parameter tuning and model selection with k-fold cross-validation
and grid search}
\usage{
cv_lightgbm(
  x,
  y,
  params = cv_param_grid(),
  n_folds = 5,
  n_threads = 1,
  seed = 42,
  verbose = TRUE
)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{params}{Parameter grid generated by \code{\link[=cv_param_grid]{cv_param_grid()}}.}

\item{n_folds}{Number of folds. Default is 5.}

\item{n_threads}{The number of parallel threads. For optimal speed,
match this to the number of physical CPU cores, not threads.
See respective model documentation for more details. Default is 1.}

\item{seed}{Random seed for reproducibility.}

\item{verbose}{Show progress?}
}
\value{
A data frame containing the complete tuning grid and the AUC values,
with the best parameter combination and the highest AUC value.
}
\description{
lightgbm - parameter tuning and model selection with k-fold cross-validation
and grid search
}
\examples{
\dontshow{if (is_installed_lightgbm()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 100,
  p = 10,
  rho = 0.6,
  coef = rnorm(5, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

params <- suppressWarnings(
  cv_lightgbm(
    sim_data$x.tr,
    sim_data$y.tr,
    params = cv_param_grid(
      n_iterations = c(100, 200),
      max_depth = c(3, 5),
      learning_rate = c(0.1, 0.5)
    ),
    n_folds = 5,
    n_threads = 1,
    seed = 42,
    verbose = FALSE
  )
)

params$df
\dontshow{\}) # examplesIf}
}
