% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_functions.R
\name{scaled_contr_poly}
\alias{scaled_contr_poly}
\title{Create scaled orthogonal polynomial contrasts for an ordered factor.}
\usage{
scaled_contr_poly(x, scale = 1, return_contr = TRUE)
}
\arguments{
\item{x}{A factor, a numeric or character vector of levels ordered least to
greatest, or a single integer greater than or equal to \code{3}.
See 'Details'.}

\item{scale}{A single positive number indicating the standard deviation
for the columns of the contrast matrix. Default is 1.}

\item{return_contr}{A logical indicating whether the contrast matrix should
be returned, or \code{x} as an ordered factor with the contrasts applied.
See 'Details'.}
}
\value{
If \code{return_contr = TRUE} a scaled orthogonal polynomial contrast
  matrix is returned.  If \code{return_contr = FALSE}, then a factor with the
  scaled orthogonal polynomial contrasts is returned.
}
\description{
The function \code{\link[stats]{contr.poly}} creates orthogonal polynomial
contrasts for an ordered factor, with the standard deviations of the
columns in the contrast matrix determined by the number of columns.  The
\code{scaled_contr_poly} function takes this contrast matrix and alters
the scale so that the standard deviations of the columns all equal
\code{scale}.
}
\details{
If \code{x} is a factor, then the non-\code{NA} levels of \code{x} are used
as the levels for the contrast matrix.  If \code{x} is a vector,
then the unique non-\code{NA} values in \code{x} in the order in which
they appear in \code{x} are used as the levels for the contrast matrix.
If \code{x} is a single integer greater than or equal to \code{3}, then
the numbers \code{1:x} are used as the levels for the contrast matrix.  Any
other value for \code{x} results in an error (if \code{x = 2}, then
polynomial contrasts are technically possible, but all binary predictors
should be treated as unordered factors and coded with sum contrasts).
\code{\link[stats]{contr.poly}} is then called to obtain an orthogonal
polynomial contrast matrix of the appropriate degree. The contrast matrix is
is put on unit scale and then multiplied by the \code{scale} argument,
resulting in an orthogonal polynomial contrast matrix where
each column has standard deviation \code{scale}.  If
\code{return_contr = TRUE}, the contrast matrix is returned.  If
\code{return_contr = FALSE}, then \code{x} is coerced to
an ordered factor with the contrast matrix applied, and \code{x} is returned.
\code{NA} is never
assigned as a level in the contrast matrix or in the factor returned by the
function, but \code{NA} values in \code{x} are not removed in the factor
returned when \code{return_contr = FALSE}.
}
\examples{
f <- factor(rep(c("a", "b", "c"), 5), ordered = TRUE)
contrasts(f) <- contr.poly(3)

# difference in contrasts
contrasts(f)
scaled_contr_poly(f)
scaled_contr_poly(f, scale = 0.5)

# different options for 'x'
scaled_contr_poly(levels(f))
scaled_contr_poly(3)
scaled_contr_poly(c(2, 5, 6))

# return factor
f2 <- scaled_contr_poly(f, return_contr = FALSE)
f2
}
\seealso{
\code{\link{named_contr_sum}} for unordered factors.
}
\author{
Christopher D. Eager <eager.stats@gmail.com>
}
