% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_pdf.R
\name{get_fields}
\alias{get_fields}
\title{Get form fields from a pdf form}
\usage{
get_fields(
  input_filepath = NULL,
  convert_field_names = FALSE,
  encoding_warning = TRUE
)
}
\arguments{
\item{input_filepath}{the path of the input PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{convert_field_names}{By default \code{pdftk} will encode certain characters
of the field names in plain text UTF-8 so if using a non-latin alphabet, your
field names might be illegible. Setting this to TRUE will turn the UFT-8 code into
characters. However this process it not guaranteed to be perfect as pdftk does
not differentiate between encoded text and regular text using escape characters.
If you have field names that intentionally include components that look like encoded characters
this will attempt to fix them. Use this option only when necessary. If TRUE,
remember to set it to TRUE when using \code{\link{set_fields}} as well.}

\item{encoding_warning}{If field names include strings that look like plain text UTF-8
codes, the function will return a warning by default, suggesting setting \code{convert_field_names} to code{TRUE}.
If \code{encoding_warning} is \code{FALSE}, these warnings will be silenced.}
}
\value{
A list of fields. With type, name and value components. To use with
  \code{\link{set_fields}} edit the value element of the fields you want to
  modify. If the field of type "button", the value will be a factor. In this
  case the factor levels describe the possible values for the field. For
  example for a checkbox the typical level names would be "Off" and "Yes",
  corresponding to non checked and checked states respectively.
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to get form fields from a pdf file.

See the reference for detailed usage of \code{pdftk}.
}
\examples{
pdfFile = system.file('simpleForm.pdf',package = 'staplr')
fields = get_fields(pdfFile)
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\seealso{
\code{link{set_fields}}
}
\author{
Ogan Mancarci
}
