% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readVcf.R
\name{readVcf}
\alias{readVcf}
\title{Read variant call format data}
\usage{
readVcf(vcfFile, ...)
}
\arguments{
\item{vcfFile}{The name of the vcf file. This can either be a plain text file
with extension (.vcf), or a gzipped file with extencion (.vcf.gz).}

\item{...}{Further arguments passed to \link[vcfR:io_vcfR]{vcfR::read.vcfR}.}
}
\value{
An object of class \code{gData}.
}
\description{
Read variant call format (VCF) data and save in gData format. This is a
wrapper around \link[vcfR:io_vcfR]{vcfR::read.vcfR} in the package \code{vcfR}. This package
needs to be installed for the function to work.
}
\references{
Knaus BJ, Grünwald NJ (2017). “VCFR: a package to manipulate and
visualizevariant call format data in R.” \emph{Molecular Ecology Resources},
\emph{17}(1), 44-53. ISSN 757, \doi{10.1111/1755-0998.12549}.
}
