% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getEffDims}
\alias{getEffDims}
\title{Extract effective dimensions}
\usage{
getEffDims(
  fitMod,
  timePoints = names(fitMod),
  EDType = c("dimension", "ratio"),
  outFile = NULL
)
}
\arguments{
\item{fitMod}{An object of class \code{fitMod}.}

\item{timePoints}{A character or numeric vector indicating the time point(s)
for which the effective dimension should be extracted. When using a character
string to reference a time point, the value has to be an exact match to one
of the existing time points. When using a number it will be matched by its
number ("timeNumber") in the timePoints attribute of the TP object.}

\item{EDType}{A character string specifying if the effective dimension
("dimension") or the ratio of effective dimensions ("ratio") should be
returned.}

\item{outFile}{A character string indicating the .csv file to which the
results should be written. If \code{NULL} no file is written.}
}
\value{
A data.frame with effective dimensions per time point.
}
\description{
Extract effective dimensions from an object of class fitMod.
The table below gives an overview of the effective dimensions and an
explanation of their meaning.\tabular{ll}{
   Effective Dimension \tab Explanation \cr
   colId \tab Linear trend along columns \cr
   rowId \tab Linear trend along rows \cr
   fCol \tab Smooth trend along columns \cr
   fRow \tab Smooth trend along rows \cr
   fColRow \tab Linear trend in rows changing smoothly along cols \cr
   colfRow \tab Linear trend in cols changing smoothly along rows \cr
   fColfRow \tab Smooth-by-smooth interaction trend over rows and cols \cr
   surface \tab Sum of smooth trends \cr
}
}
\examples{
\donttest{
## Using the first example dataset (PhenovatorDat1):
data("PhenovatorDat1")
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))

## Fit a SpATS model on few time points:
modPhenoSp <- fitModels(TP = phenoTP,
                        trait = "EffpsII",
                        timePoints = c(1, 6, 20))

## Extract the effective dimensions for all available time points in the
## model object:
effDimSp <- getEffDims(modPhenoSp)
}

}
\seealso{
Other functions for spatial modeling: 
\code{\link{fitModels}()},
\code{\link{getCorrected}()},
\code{\link{getGenoPred}()},
\code{\link{getHerit}()},
\code{\link{getVar}()},
\code{\link{plot.fitMod}()},
\code{\link{summary.fitMod}()}
}
\concept{functions for spatial modeling}
