% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{optimPenaLik}
\alias{optimPenaLik}
\title{Variable selection based on the combined penalty CL= (1-w)L0 + wL1}
\usage{
optimPenaLik(Data, lamda, w, standardize = TRUE, algorithms = c("QN",
  "hjk"))
}
\arguments{
\item{Data}{should have the following structure: the first column must be the response variable y}

\item{lamda}{tuning penalty parameter}

\item{w}{the weight parameter for the sum (1-w)L0+ wL1}

\item{standardize}{standardize Logical flag for x variable standardization, prior to fitting the model sequence.
The coefficients are always returned on the original scale. Default is standardize=TRUE}

\item{algorithms}{select between BFGS ('QN') or Hooke-Jeeves (hjk) algorithm.}
}
\value{
a list with the shrinked coefficients and the names of the selected variables, i.e those variables with
estimated coefficient different from zero.
}
\description{
Methods to use for optimization include Hooke-Jeeves derivative-free minimization algorithm (hjk),
or the BFGS method (modified Quasi-Newton). This method does variable selection by shrinking
the coefficients towards zero using the combined penalty (CL= (1-w)L0 + wL1).
}
\details{
it is recommended to use the tuneParam function to tune parameters lamda and w prior
using the optimPenaLik function.
}
\examples{
# use the optimPenaLik function on a simulated dataset, with given lamda and w.
\dontrun{
set.seed(14)
beta    <- c(3, 2, -1.6, -1)
noise   <- 5
simData <- SimData(N=100, beta=beta, noise=noise, corr=TRUE)

# use BFGS

before  <- Sys.time()
PenalQN <- optimPenaLik(Data=simData, lamda=1.5, w=0.7,
                     algorithms=c("QN"))
(tot <- Sys.time()-before)
PenalQN


# use Hooke-Jeeves algorithm

before  <- Sys.time()
Penalhjk <- optimPenaLik(Data=simData, lamda=1.5, w=0.7,
                       algorithms=c("hjk"))
(totRun  <- Sys.time() - before)
# total run of approx 0.25sec

Penalhjk
}

}
\seealso{
\code{\link[stats]{optim}}
}
