% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_results-class.R
\name{plot.simulation_results}
\alias{plot.simulation_results}
\title{Plot the results of a simulation}
\usage{
\method{plot}{simulation_results}(x, replicates = 1, ...)
}
\arguments{
\item{x}{a simulation_results object}

\item{replicates}{which replicates to plot (default is one, or the first)}

\item{...}{further arguments passed to/from other methods}
}
\description{
Methods to visually inspect the results of a simulation. Both linear graphs
and spatial-explicit grids are generated for all timesteps to illustrate
population changes through time and space. Note, this function can be wrapped
in a *png()* call to write several images to disk for creating animations.
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kernel_dispersal(max_distance = 2000,
                                        dispersal_kernel = exponential_dispersal_kernel(
                                          distance_decay = 1000)),
                          density_dependence = ceiling_density())

sim <- simulation(landscape = ls,
                  population_dynamics = pd,
                  habitat_dynamics = NULL,
                  timesteps = 20)

# Plot the spatial distributions of total cell populations
plot(sim) 
}
}
