% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_cycle}
\alias{plot_cycle}
\title{Cycle-Subseries Plot for an stlplus Object}
\usage{
plot_cycle(x, layout = c(x$pars$n.p, 1), col = "#0080ff", xlab = "Time",
  ylab = "Seasonal", panel = function(x, y, ...) {    
  lattice::panel.segments(x, rep(.midmean(y), length(x)), x, y, col = col) },
  ...)
}
\arguments{
\item{x}{object of class \code{"stlplus"}.}

\item{layout, col, xlab, ylab, panel, \ldots}{parameters to be passed to \code{xyplot()}.}
}
\value{
object of class \code{"trellis"}.
}
\description{
Plots the seasonal component by cycle-subseries, with lines emanating
from the midmean of the values within each cycle-subseries.
}
\references{
R. B. Cleveland, W. S. Cleveland, J. E.  McRae, and I. Terpenning (1990) STL:  A  Seasonal-Trend  Decomposition  Procedure Based on Loess. \emph{Journal of Official Statistics}, \bold{6}, 3--73.
}
\seealso{
\code{\link{stlplus}}
}

