#include <Rcpp.h>
#include <math.h>
#include <cmath>
#include "vmp_tpd.h"
#include "normalizing_constant.h"
#include "s_given_rho_likelihood.h"

//' @export
// [[Rcpp::export]]

double optim_loop_vmp(double dt, Rcpp::NumericVector rho_vec, double lambda_vm, double sigma_vm, double mu_vm,double nc,Rcpp::NumericVector S_1, Rcpp::NumericVector S_2, double mu1, double mu2, double sigma1, double sigma2){
  double ff{0};
  double n_constant;
  Rcpp::NumericVector V3 = {mu1,mu2};
  Rcpp::NumericVector V4 = {sigma1,sigma2};
  for(int j=0;j<nc-1;j++){
    Rcpp::NumericVector V1 = {S_1[j+1],S_2[j+1]};
    Rcpp::NumericVector V2 = {S_1[j],S_2[j]};
    n_constant = normalizing_constant(dt,acos(rho_vec[j]),mu_vm,lambda_vm,sigma_vm);
    ff = ff+s_given_rho_likelihood(dt,V1,V2,V3,V4,rho_vec[j+1])+log(2/sqrt(1-pow(rho_vec[j+1],2)))+log(vmp_tpd(dt,acos(rho_vec[j+1]),acos(rho_vec[j+1]),lambda_vm,sigma_vm,mu_vm)/n_constant);
  }
  return(ff);
}
