% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharpe.R
\name{sharpe}
\alias{sharpe}
\title{Sharpe Ratio}
\usage{
sharpe(gains = NULL, prices = NULL, rf = 0)
}
\arguments{
\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{rf}{Numeric value.}
}
\value{
Numeric value.
}
\description{
Calculates Sharpe ratio from vector of gains or prices. The formula is: 
\code{(mean(gains) - rf) / sd(gains)}, where \code{rf} is some risk-free rate 
of return.
}
\examples{
# Simulate daily gains over a 5-year period
set.seed(123)
stock.gains <- rnorm(252 * 5, 0.0005, 0.01)

# Calculate Sharpe ratio using risk-free return of 0
sharpe(stock.gains)


}
