% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.rule.surv.R
\name{table.rule.surv}
\alias{table.rule.surv}
\title{Tabulate Stopping Rule (Survival data)}
\usage{
table.rule.surv(rule, dec = 0)
}
\arguments{
\item{rule}{A \code{rule.surv} object calculated by \code{calc.rule.surv()} function}

\item{dec}{Number of decimal places to which the stagewise total follow-up times should be rounded}
}
\value{
A matrix with two columns: total follow up time and their corresponding rejection boundary
}
\description{
Summarize a stopping rule in a condensed tabular format
}
\examples{
\dontrun{gp_rule = calc.rule.surv(n=50,p0=0.20,alpha=0.10,type="GP",tau=100,param=c(1,1000))
table.rule.surv(gp_rule,2)
}
}
