% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_environment.R
\name{storr_environment}
\alias{storr_environment}
\alias{driver_environment}
\title{Environment object cache driver}
\usage{
storr_environment(
  envir = NULL,
  hash_algorithm = NULL,
  default_namespace = "objects"
)

driver_environment(envir = NULL, hash_algorithm = NULL)
}
\arguments{
\item{envir}{The environment to point the storr at.  The default
creates an new empty environment which is generally the right
choice.  However, if you want multiple environment storrs
pointing at the same environment then pass the \code{envir}
argument along.}

\item{hash_algorithm}{Name of the hash algorithm to use.  Possible
values are "md5", "sha1", and others supported by
\link[digest:digest]{digest::digest}.  If not given, then we will default to
"md5".}

\item{default_namespace}{Default namespace (see \link{storr}).}
}
\description{
Fast but transient environment driver.  This driver saves objects
in a local R environment, without serialisation.  This makes
lookup fast but it cannot be saved across sessions.  The
environment storr can be made persistent by saving it out as a
file storr though.
}
\examples{

# Create an environment and stick some random numbers into it:
st <- storr_environment()
st$set("foo", runif(10))
st$get("foo")

# To make this environment persistent we can save it to disk:
path <- tempfile()
st2 <- st$archive_export(path)
# st2 is now a storr_rds (see ?storr_rds), and will persist across
# sessions.

# or export to a new list:
lis <- st$export(list())
lis
}
