% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{inbtw}
\alias{inbtw}
\title{Elements Inbetween Values Within a (Atomic) Vector}
\usage{
inbtw(x, from, to, left = TRUE, right = TRUE)
}
\arguments{
\item{x}{atomic vector.}

\item{from}{vector of length 1 specifying the element to start with on the left.}

\item{to}{vector of length 1 specifying the element to end with on the right.}

\item{left}{logical vector of length 1 specifying whether the leftmost element,
\code{from}, should be included in the return object.}

\item{right}{logical vector of length 1 specifying whether the rightmost element,
\code{to}, should be included in the return object.}
}
\value{
vector of the same type as \code{x} that only includes elements in \code{x}
inbetween (by position) \code{from} and \code{to}, which may or may not include
\code{from} and \code{to} themselves, depending on \code{left} and \code{right},
respectively.
}
\description{
\code{inbtw} extracts all elements inbetween (by position) two specific elements
of a (atomic) vector. This can be useful when working with rownames and colnames
since \code{seq} does not work with names. Primary for character vectors but
can be used with other typeof.
}
\details{
An error is returned if either \code{from} or \code{to} don't appear in \code{x}
or appear more than once in \code{x}.
}
\examples{
# character vector
row_names <- inbtw(x = row.names(LifeCycleSavings), from = "China", to = "Peru")
LifeCycleSavings[row_names, ] # default use
row_names <- inbtw(x = row.names(LifeCycleSavings), from = "China", to = "Peru",
   right = FALSE, left = FALSE)
LifeCycleSavings[row_names, ] # use with right and left arguments FALSE
try_expr(inbtw(x = row.names(LifeCycleSavings), from = "china",
   to = "peru")) # error due to `from` and `to` not appearing in `x`
try_expr(inbtw(x = rep.int(x = row.names(LifeCycleSavings), times = 2), from = "China",
   to = "Peru")) # error due to `from` and `to` appearing more than once in `x`
# numeric vector
vec <- sample(x = 150:199, size = 50)
inbtw(x = vec, from = 150, to = 199)
# list vector (error)
lst <- list(FALSE, 3L, 9.87, "abc", factor("lvl"))
try_expr(inbtw(x = lst, from = 3L, to = "abc")) # error because `lst` is a
   # list vector and not an atomic vector
}
