/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.ListOption;
import com.github.javacliparser.Option;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.tasks.TaskMonitor;

public abstract class HeterogeneousEnsembleAbstract
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ListOption baselearnersOption = new ListOption("baseClassifiers", 'b', "The classifiers the ensemble consists of.", new ClassOption("learner", ' ', "", Classifier.class, "trees.HoeffdingTree"), new Option[]{new ClassOption("", ' ', "", Classifier.class, "bayes.NaiveBayes"), new ClassOption("", ' ', "", Classifier.class, "functions.Perceptron"), new ClassOption("", ' ', "", Classifier.class, "functions.SGD"), new ClassOption("", ' ', "", Classifier.class, "lazy.kNN"), new ClassOption("", ' ', "", Classifier.class, "trees.HoeffdingTree")}, ',');
    public IntOption gracePerionOption = new IntOption("gracePeriod", 'g', "How many instances before we reevalate the best classifier", 1, 1, Integer.MAX_VALUE);
    public IntOption activeClassifiersOption = new IntOption("activeClassifiers", 'k', "The number of active classifiers (used for voting)", 1, 1, Integer.MAX_VALUE);
    public FlagOption weightClassifiersOption = new FlagOption("weightClassifiers", 'p', "Uses online performance estimation to weight the classifiers");
    protected Classifier[] ensemble;
    protected double[] historyTotal;
    protected Integer instancesSeen;
    List<Integer> topK;

    @Override
    public String getPurposeString() {
        return "The model-free heterogeneous ensemble as presented in 'Having a Blast: Meta-Learning and Heterogeneous Ensembles for Data Streams' (ICDM 2015).";
    }

    public int getEnsembleSize() {
        return this.ensemble.length;
    }

    public String getMemberCliString(int idx) {
        return this.ensemble[idx].getCLICreationString(Classifier.class);
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[inst.classAttribute().numValues()];
        for (int i = 0; i < this.topK.size(); ++i) {
            double[] memberVotes = HeterogeneousEnsembleAbstract.normalize(this.ensemble[this.topK.get(i)].getVotesForInstance(inst));
            double weight = 1.0;
            if (this.weightClassifiersOption.isSet()) {
                weight = this.historyTotal[this.topK.get(i)];
            }
            int n = HeterogeneousEnsembleAbstract.maxIndex(memberVotes);
            votes[n] = votes[n] + 1.0 * weight;
        }
        return votes;
    }

    @Override
    public void setModelContext(InstancesHeader ih) {
        super.setModelContext(ih);
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i].setModelContext(ih);
        }
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void getModelDescription(StringBuilder arg0, int arg1) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        Option[] learnerOptions = this.baselearnersOption.getList();
        this.ensemble = new Classifier[learnerOptions.length];
        for (int i = 0; i < learnerOptions.length; ++i) {
            monitor.setCurrentActivity("Materializing learner " + (i + 1) + "...", -1.0);
            this.ensemble[i] = (Classifier)((ClassOption)learnerOptions[i]).materializeObject(monitor, repository);
            if (monitor.taskShouldAbort()) {
                return;
            }
            monitor.setCurrentActivity("Preparing learner " + (i + 1) + "...", -1.0);
            this.ensemble[i].prepareForUse(monitor, repository);
            if (!monitor.taskShouldAbort()) continue;
            return;
        }
        super.prepareForUseImpl(monitor, repository);
        this.topK = HeterogeneousEnsembleAbstract.topK(this.historyTotal, this.activeClassifiersOption.getValue());
    }

    protected static List<Integer> topK(double[] scores, int k) {
        double[] scoresWorking = Arrays.copyOf(scores, scores.length);
        ArrayList<Integer> topK = new ArrayList<Integer>();
        for (int i = 0; i < k; ++i) {
            int bestIdx = HeterogeneousEnsembleAbstract.maxIndex(scoresWorking);
            topK.add(bestIdx);
            scoresWorking[bestIdx] = -1.0;
        }
        return topK;
    }

    protected static int maxIndex(double[] scores) {
        int bestIdx = 0;
        for (int i = 1; i < scores.length; ++i) {
            if (!(scores[i] > scores[bestIdx])) continue;
            bestIdx = i;
        }
        return bestIdx;
    }

    protected static double[] normalize(double[] input) {
        int i;
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            sum += input[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] / sum;
        }
        return input;
    }
}

