/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.ArrayList;
import java.util.Random;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class MixedGenerator
extends AbstractOptionHandler
implements InstanceStream {
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 2);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        @Override
        public int determineClass(double v, double w, double x, double y) {
            boolean z;
            boolean bl = z = y < 0.5 + 0.3 * Math.sin(Math.PI * 3 * x);
            if (v == 1.0 && w == 1.0 || v == 1.0 && z || w == 1.0 && z) {
                return 0;
            }
            return 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double v, double w, double x, double y) {
            boolean z;
            boolean bl = z = y < 0.5 + 0.3 * Math.sin(Math.PI * 3 * x);
            if (v == 1.0 && w == 1.0 || v == 1.0 && z || w == 1.0 && z) {
                return 1;
            }
            return 0;
        }
    }};

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        double v = 0.0;
        double w = 0.0;
        double x = 0.0;
        double y = 0.0;
        double group = 0.0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            v = this.instanceRandom.nextDouble() < 0.5 ? 0.0 : 1.0;
            w = this.instanceRandom.nextDouble() < 0.5 ? 0.0 : 1.0;
            x = this.instanceRandom.nextDouble();
            y = this.instanceRandom.nextDouble();
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(v, w, x, y);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0.0) && (this.nextClassShouldBeZero || group != 1.0)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setValue(0, v);
        inst.setValue(1, w);
        inst.setValue(2, x);
        inst.setValue(3, y);
        inst.setDataset(header);
        inst.setClassValue(group);
        return new InstanceExample(inst);
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        ArrayList<String> booleanLabels = new ArrayList<String>();
        booleanLabels.add("0");
        booleanLabels.add("1");
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute attribute1 = new Attribute("v", booleanLabels);
        Attribute attribute2 = new Attribute("w", booleanLabels);
        Attribute attribute3 = new Attribute("x");
        Attribute attribute4 = new Attribute("y");
        ArrayList<String> classLabels = new ArrayList<String>();
        classLabels.add("positive");
        classLabels.add("negative");
        Attribute classAtt = new Attribute("class", classLabels);
        attributes.add(attribute1);
        attributes.add(attribute2);
        attributes.add(attribute3);
        attributes.add(attribute4);
        attributes.add(classAtt);
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    protected static interface ClassFunction {
        public int determineClass(double var1, double var3, double var5, double var7);
    }
}

