% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_init.R
\name{mlm_init}
\alias{mlm_init}
\title{Compare Machine Learning Models}
\usage{
mlm_init(
  formula,
  train_data,
  fit_models,
  sort_v = NULL,
  n_models = 9999,
  classification = FALSE,
  seed = NULL,
  ...
)
}
\arguments{
\item{formula}{The regression formula or classification formula. This formula
should be linear.}

\item{train_data}{A data.frame object that includes data to be trained on.}

\item{fit_models}{A character vector with all the possible Machine Learning
 regressors that are currently being fit. The user may specify a subset of
 them using a character vector.
 \tabular{rl}{
   ada \tab AdaBoost Regressor \cr
   br \tab Bayesian Ridge \cr
   dt \tab Decision Tree Regressor \cr
   dummy \tab Dummy Regressor \cr
   en \tab Elastic Net \cr
   et \tab Extra Trees Regressor \cr
   gbr \tab Gradient Boosting Regressor \cr
   huber \tab Huber Regressor \cr
   knn \tab K Neighbors Regressor \cr
   lar \tab Least Angle Regression \cr
   lasso \tab Lasso Regression \cr
   lightgbm \tab Light Gradient Boosting Machine \cr
   llar \tab Lasso Least Angle Regression \cr
   lr \tab Linear Regression \cr
   omp \tab Orthogonal Matching Pursuit \cr
   par \tab Passive Aggressive Regressor \cr
   rf \tab Random Forest Regressor\cr
   ridge \tab Ridge Regression
 }
If classification is set to `TRUE`, these models can be used depending on user.
These are the default values for classification:
 \tabular{rl}{
   ada \tab AdaBoost Classifier \cr
   dt \tab Decision Tree Classifier\cr
   dummy \tab Dummy Classifier\cr
   et \tab Extra Trees Classifier \cr
   gbc \tab Gradient Boosting Classifier\cr
   knn \tab K Neighbors Classifier\cr
   lda \tab Linear Discriminant Analysis\cr
   lightgbm \tab Light Gradient Boosting Machine\cr
   lr \tab Logistic Regression\cr
   nb \tab Naive Bayes \cr
   qda \tab Quadratic Discriminant Analysis\cr
   rf \tab Random Forest Classifier\cr
   ridge \tab Ridge Classifier\cr
   svm \tab SVM - Linear Kernel
 }}

\item{sort_v}{A character vector indicating what to sort the tuned models on.
Default value is `NULL`.}

\item{n_models}{A defaulted integer to return the maximum number of models.}

\item{classification}{A Boolean value tag to indicate if classification
methods should be used.}

\item{seed}{An integer value to set the seed of the python environment.
Default value is set to `NULL`.}

\item{...}{Additional arguments passed to the setup function in `PyCaret`.}
}
\value{
A list object that contains all the fitted models and the CV
  predictive accuracy. With a class attribute of `"mlm_stressor"`.
}
\description{
Through the \href{https://pycaret.gitbook.io/docs/get-started/quickstart}{PyCaret}
  module from `python`, this function fits many machine
  learning models simultaneously without requiring any `python`
  programming on the part of the user. This is the core function to fitting
  the initial models. This function is the backbone to fitting all the models.
}
\details{
The formula should be linear. However, that does not imply a linear
  fit. The formula is a convenient way to separate predictor
  variables from explanatory variables.

  `PyCaret` is a `python` module where machine learning models can be fitted with
  little coding by the user. The pipeline that `PyCaret` uses has a
  setup function to parameterize the data that is easy for all the models to
  fit on. Then compare models function is executed which fits all the models
  that are currently available. This process takes less than five minutes for
  data.frame objects that are less than 10,000 rows.
}
\examples{
\dontshow{if (python_avail()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 lm_test <- data_gen_lm(20)
 create_virtualenv()
 mlm_lm <- mlm_regressor(Y ~ ., lm_test)
\dontshow{\}) # examplesIf}
}
