% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_explore.R
\name{vis_response_counts}
\alias{vis_response_counts}
\title{vis_response_counts}
\usage{
vis_response_counts(
  tab,
  response,
  main = paste0("Total responses by student (", attr(tab, "table"), ")"),
  xlab = "Student UID",
  ylab = "Response count",
  ...
)
}
\arguments{
\item{tab}{A regularised StudentLife tibble (i.e., an object of class
\code{reg_SL_tbl}) as
produced by the function \code{\link[studentlife]{regularise_time}}.}

\item{response}{A character string naming one of the columns
in \code{tab} that is not in \code{attr(tab, "blocks")}. If
missing then this defaults to the first such column name.}

\item{main}{The plot title, passed to \code{\link[graphics]{barplot}}.}

\item{xlab}{The x axis label, passed to \code{\link[graphics]{barplot}}.}

\item{ylab}{The y axis label, passed to \code{\link[graphics]{barplot}}.}

\item{...}{Arguments passed to \code{\link[graphics]{barplot}}.}
}
\value{
A named numeric vector of response counts,
sorted in descending order.
}
\description{
Produce an ordered bar plot of the
total number of responses
for each student in a regularised SL_tbl.
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

tab_PAM <- load_SL_tibble(schema = "EMA", table = "PAM", location = d)

reg_PAM <- regularise_time(
  tab_PAM, blocks = c("day", "epoch"), m = mean(picture_idx, na.rm = TRUE))

vis_response_counts(reg_PAM, response = "m")

}
