% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stats.R
\name{summary_stats}
\alias{summary_stats}
\title{Calculate summary statistics on a data frame}
\usage{
summary_stats(data, measure, type)
}
\arguments{
\item{data}{a data frame}

\item{measure}{a numeric variable. Response variable - summary statistics
will be returned for this variable}

\item{type}{a string variable. Controls whether a normal or t distribution is used for CI
calculation. Defaults to "norm".}
}
\description{
Functions from dplyr are used to automate the process of
 calculating basic summary statistics on a data frame. Returned
 statistics include mean, standard deviation, standard error, count,
 and 95% confidence intervals. Functions are given for calculating
 confidence intervals from a normal distribution (summary_stats) and
 from a t-distribution (summary_stats.t)
}
\examples{
library(summariser)
library(dplyr)
iris \%>\%
  summary_stats(Sepal.Length)
}
