% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplechoice.R
\name{multi_freq}
\alias{multi_freq}
\title{Generate an UpSet plot for multiple-choice questions}
\usage{
multi_freq(
  dataset,
  question,
  group_by = NULL,
  subgroups_to_exclude = NULL,
  weights = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{dataset}{The input dataframe (or tibble) of survey questions}

\item{question}{The columns that contain each of the response options for a
question, can be selected by using \strong{tidyselect} semanatics or providing a
vector of column names or numbers}

\item{group_by}{Optional variable to group the analysis. If provided, the
frequencies and counts will be calculated within each subgroup.}

\item{subgroups_to_exclude}{Optional vector specifying subgroups to exclude
from the analysis.}

\item{weights}{Optional variable containing survey weights. If provided,
frequencies and counts will be weighted accordingly.}

\item{na.rm}{Logical indicating whether to remove NA values from \code{question}
before analysis.}
}
\value{
An upset plot visualizing the distribution of responses to the multiple-choice question.
}
\description{
Visualize multiple-choice question responses with an upset plot, a visual
tool for exploring the overlap and distribution of multiple-choice question
responses. The function supports optional subgrouping of data using the
\code{group_by} variable, exclusion of specific subgroups with
'subgroups_to_exclude,' and data weighting with the 'weights' parameter.
Users can also choose to exclude NA values from the questions prior to
analysis using the 'na.rm' parameter.
}
\examples{

#Use dplyr to select questions
library(dplyr)

#Basic Upset plot

#Use `group_by` to partition the question into several groups
 multi_freq(berlinbears, question = dplyr::starts_with('will_eat'), group_by
 = gender)

#to ignore a subgroup, use `subgroups_to_exclude`
multi_freq(berlinbears, question = dplyr::starts_with('will_eat'), group_by =
gender, subgroups_to_exclude = NA)

#Specifiy survey weights with `weights`
 multi_freq(berlinbears, question = dplyr::starts_with('will_eat'), group_by
 = gender, weights = weights)



}
\seealso{
Other multiple-choice questions: 
\code{\link{multi_summary}()},
\code{\link{multi_table}()}
}
\concept{multiple-choice questions}
