% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIN3df.R
\name{LIN3df}
\alias{LIN3df}
\title{Lin's estimator for three gap times distribution function.}
\usage{
LIN3df(object, x, y, z)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the triviate distribution
function.}

\item{y}{The second time for obtaining estimates for the triviate distribution
function.}

\item{z}{The third time for obtaining estimates for the triviate distribution
function.}
}
\value{
Vector with the Lin's estimates for three gapes times distribution
function.
}
\description{
Provides estimates for three gap times distribution function based
on the extension the Lin's estimator.
}
\examples{
data("bladder5state")
b4state<-multidf(gap1=bladder5state$y1, event1=bladder4state$d1, 
                 gap2=bladder5state$y2, event2=bladder4state$d2,
                 gap3=bladder5state$y3, status=bladder4state$d3)
                 
head(b4state)[[1]]

LIN3df(b4state, x=13, y=20, z=40)

b4<-multidf(gap1=bladder4$t1, event1=bladder4$d1, 
            gap2=bladder4$t2-bladder4$t1, event2=bladder4$d2,
            gap3=bladder4$t3-bladder4$t2, status=bladder4state$d3)

LIN3df(b4, x=13, y=20, z=40)

}
\references{
Lin, D. Y., Sun, W. and Ying, Z. (1999). Nonparametric estimation 
of the  gap time distributions for serial events with censored data, Biometrika
86, 59-70.
}
\seealso{
\code{\link{LDM3df}}, \code{\link{KMW3df}} and \code{\link{WCH3df}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
