% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{regFit}
\alias{regFit}
\title{survivalsvm (regression approach)}
\usage{
regFit(
  X,
  Y,
  delta,
  meth_par = 1,
  kernel_type = "lin_kernel",
  kernel_pars = NA,
  bin_cat = integer(0),
  opt_alg = "quadprog",
  sgf_sv = 5,
  sigf = 7,
  maxiter = 20,
  margin = 0.05,
  bound = 10,
  eig.tol = 1e-06,
  conv.tol = 1e-07,
  posd.tol = 1e-08
)
}
\arguments{
\item{X}{[\code{matrix(1)}]\cr
design matrix.}

\item{Y}{[\code{vector(1)}]\cr
vector of survival times.}

\item{delta}{[\code{vector(1)}]\cr
vector of status: 0 if censored and 1 else.}

\item{meth_par}{[\code{numeric(1)}]\cr
parameter of regularization.}

\item{kernel_type}{[\code{character(1)}]\cr
type of the kernel.}

\item{kernel_pars}{[\code{vector(1)}]\cr
parameter of kernel.}

\item{bin_cat}{[\code{vector(1)}]\cr
indexes of binary/categorial variables.}

\item{opt_alg}{[\code{character(1)}]\cr
program used to solve the optimization problem. This most be one of the two possibilities \code{\link[pracma]{quadprog}} or \code{\link[kernlab]{ipop}}.}

\item{sgf_sv}{[\code{integer(1)}]\cr
number of digits to be retained in the solution.}

\item{sigf}{[\code{integer(1)}]\cr
used by \code{ipop}. See \code{\link[kernlab]{ipop}} for more details.}

\item{maxiter}{[\code{integer(1)}]\cr
used by \code{ipop}. See \code{\link[kernlab]{ipop}} for more details.}

\item{margin}{[\code{numeric(1)}]\cr
used by \code{ipop}. See \code{\link[kernlab]{ipop}} for more details.}

\item{bound}{[\code{numeric(1)}]\cr
used by \code{ipop}. See \code{\link[kernlab]{ipop}} for more details.}

\item{eig.tol}{[\code{numeric(1)}]\cr
used by \code{nearPD} for adjusting positive definiteness. See \code{\link[Matrix]{nearPD}} for detail.}

\item{conv.tol}{[\code{numeric(1)}]\cr
used by \code{nearPD} for adjusting positive definiteness. See \code{\link[Matrix]{nearPD}} for detail.}

\item{posd.tol}{[\code{numeric(1)}]\cr
used by \code{nearPD} for adjusting positive definiteness. See \code{\link[Matrix]{nearPD}} for detail.}
}
\value{
[\code{\link{RegFitObj}(1)}]
object of class \code{RegFitObj} containing elements:
\tabular{ll}{
   \code{Beta} \tab solution of the quadratic optimization problem, \cr
   \code{SV} \tab support vector machines,\cr
   \code{Kernel} \tab kernel matrix, an object of class \code{Kernel},\cr
   \code{b0} \tab estimated offset,\cr
   \code{OptMeth} \tab program used to solve the quadratic optimization problem.\cr
 }
}
\description{
The function \code{regFit} fits a \code{survivalsvm} model based on the regression approach.
}
\author{
Cesaire J. K. Fouodo
}
\keyword{internal}
