% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_events.R
\name{renewal}
\alias{renewal}
\alias{renewhr}
\alias{renewaft}
\title{Generate random recurrent episodes under a renewal Poisson process}
\usage{
renewhr(SURVIVAL, hr, prevtime)

renewaft(SURVIVAL, prevtime, aft)
}
\arguments{
\item{SURVIVAL}{Object of survival class}

\item{hr}{Vector of hazard ratios}

\item{prevtime}{Vector of previous survival times}

\item{aft}{Vector of accelerated failure time ratios}
}
\value{
Vector of survival times

Vector of survival times
}
\description{
Generate a random draws from the distribution of recurrent set of survival
times under a renewal Poisson process following Leemis (1987)
}
\section{Functions}{
\itemize{
\item \code{renewhr()}: Recurrent episodes under a proportional hazard model

\item \code{renewaft()}: Recurrent episodes under an accelerated failure time model

}}
\examples{
s_obj <- s_exponential(fail = 0.4, t = 1)
hr <- c(1,1,0.5,0.5)
time1 <- rsurvhr(s_obj, hr)
time2 <- renewhr(s_obj, hr, time1)

s_obj2 <- s_exponential(fail = 0.4, t = 1)
aft <- c(1,1,0.5,0.5)
timea <- rsurvaft(s_obj2, aft)
timeb <- renewaft(s_obj2, aft, timea)
}
