% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{layout4bipartite}
\alias{layout4bipartite}
\alias{layout4diagram}
\title{Create a Layout Matrix for a Bipartite Graph}
\usage{
layout4bipartite(nrow, ncol, rowsLeft = TRUE)

layout4diagram(nrow, ncol, rowsLeft = TRUE)
}
\arguments{
\item{nrow}{Numeric specifying the number of rows of the biadjacency matrix.}

\item{ncol}{Numeric specifying the number of columns of the biadjacency matrix.}

\item{rowsLeft}{Logical specifying whether the rows of the biadjacency matrix should appear to the left of the columns.}
}
\value{
A matrix.
}
\description{
A helper function for creating a layout matrix for a bipartite graph, based on the dimensions of its biadjacency matrix.
}
\details{
This is essentially an alternative for \code{layout_as_bipartite()} from the \pkg{igraph} package.
Bipartite graphs are typically represented by a biadjacency matrix, the dimensions of which can be used for constructing the layout.
In addition, the coordinates for the vertices are somewhat different from those in \pkg{igraph}.
}
