% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_N_duration.R
\name{events_summary}
\alias{events_summary}
\title{Events Summary}
\usage{
events_summary(data, step2time)
}
\arguments{
\item{data}{A dataframe with a \code{keep} column (representing which rows
are defined as events of collective motion) and a set column.}

\item{step2time}{The sampling frequency of the dataframe (how many seconds
are between each row of the data).}
}
\value{
A dataframe with 3 columns: \code{set}, \code{ev_count} (number of
 events), and \code{dur} (duration of events in seconds).
}
\description{
This function summarizes the number of events and their total
 duration in the dataset.
}
\examples{

data <- data.frame(
set = c(rep('1', 50), rep('2', 50)),
keep = c(rep(FALSE, 10), rep(TRUE, 70), rep(FALSE, 20))
)

time_per_row <- 1 # seconds

events_summary(data, time_per_row)

}
\seealso{
\code{\link{events_dur}}, \code{\link{events_n}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
