% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_age}
\alias{pin_age}
\title{Calculate age of \code{pin} for a given date}
\usage{
pin_age(pin, date = Sys.Date(), timespan = "years", verbose = TRUE)
}
\arguments{
\item{pin}{A vector of class \code{pin}. See \link{as.pin}.}

\item{date}{Date at which age is calculated. If a vector is provided it must be
of the same length as the \code{pin} argument.}

\item{timespan}{Timespan to use to calculate age. The actual timespans are:
\itemize{
  \item \code{years} (Default)
  \item \code{months}
  \item \code{weeks}
  \item \code{days}
}}

\item{verbose}{Should messages be printed? Default is \code{TRUE}.}
}
\value{
Age as an integer vector.
}
\description{
Calculate the age in full years for a given date.
}
\examples{
# Example with someone born today
today_pin <- 
  paste(paste(unlist(strsplit(as.character(Sys.Date()),split = "-")), collapse = ""),
        "0000",sep="")
pin_age(today_pin)

# Examples taken from SKV 704 (see references)
ex_pin <- c("196408233234", "186408833224")
pin_age(ex_pin, date = "2012-01-01")

}
\references{
\itemize{
 \item Skatteverket, \href{https://github.com/rOpenGov/sweidnumbr/blob/master/docs/skv704-8.pdf}{\emph{Personnummer}}. SKV 704. (2007)
}
}
