% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpFunctions.R
\name{exogenous_fn}
\alias{exogenous_fn}
\title{Modify exogenous variables in data frame}
\usage{
exogenous_fn(exogenous, newdata)
}
\arguments{
\item{exogenous}{list such that \code{exogenous[[i]]} represents the value 
(or a vector of values of the same size as \code{nrow(newdata)}) which will 
be exogenously assigned to the variable \code{names(exogenous)[[i]]} in 
\code{newdata} i.e., \code{newdata[, names(exogenous)[i]] <- exogenous[[i]]}.
If \code{newdata} is \code{NULL} and \code{exogenous} is not \code{NULL} then
\code{newdata} is set to \code{object$data}.
This argument is especially useful for causal inference when some endogenous 
(dependent) variables should be exogenously assigned with some values i.e.,
in the right hand side of the \code{formula} and \code{formula2}.
The purpose of the \code{exogeneous} argument is just a \code{convenience} so
equivalently it is possible to exogenously provide the values to variables
via \code{newdata} argument.}

\item{newdata}{data frame.}
}
\value{
The function returns data frame which is similar to \code{newdata} 
but some values of this data frame are set according to \code{exogenous}.
}
\description{
Change some values of the exogenous variables in a data frame.
}
\details{
This function changes \code{exogenous} variables in \code{newdata}.
}
