% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchicalModels.R
\name{choosethin}
\alias{choosethin}
\title{Calibrate Thinning}
\usage{
choosethin(
  l,
  a,
  L_fixed = NA,
  model,
  relESStarget = 0.3,
  burnin = 100,
  matrpertheta = length(l)^2,
  silent = TRUE,
  maxthin = 10000
)
}
\arguments{
\item{l}{observed row sum}

\item{a}{observerd column sum}

\item{L_fixed}{Matrix containing known values of L, where NA
signifies that an element is not known. If \code{L_fixed} equates
to \code{NA} (the default) then no values are assumed to be known.}

\item{model}{Underlying model for p and lambda.}

\item{relESStarget}{Target for the relative effective sample size,
must be in (0,1). Default 0.3.}

\item{burnin}{number of iterations for the burnin. Defaults to 5%
of the steps in the sampling part.}

\item{matrpertheta}{number of matrix updates per update of theta.}

\item{silent}{(default FALSE) suppress all output (including progress bars).}

\item{maxthin}{Upper bound on thinning to consider. Default 10000.}
}
\value{
An integer describing the amount of thinning required.
}
\description{
Attempts to automatically choose a thinning paramter to achieve an
overall relative effective sample size (defined as the effective
sample size divided by the number of samples) for all parameters in
the model (that do not seem to be constant). This function provides
no guarantees that the desired relative effective sample size
(rESS) will actually be achieved - it is best treated as a rough
guide for this.
}
\details{
The approach used involves a pilot run of the sampler, followed by
a computation of the acf (autocorrelation function) for each
component. The acf is used only up to (and excluding) the point
used where it becomes negative for the first time. This part of the
acf is then used to approximate the rESS and to determine the
amount of thinning needed. The reported result is the thinning
needed to achieve the rESS for all components (the matrix as well
as the parameter theta). The initial pilot run may not be
sufficient and further pilot runs may have to be started.
}
\examples{
set.seed(12689)
n <- 10
m <- Model.Indep.p.lambda(Model.p.BetaPrior(n),
                          Model.lambda.GammaPrior(n,scale=1e-1))
x <- genL(m)
l <- rowSums(x$L)
a <- colSums(x$L)
choosethin(l,a,model=m)
choosethin(l,a,model=m,relESStarget=0.7)
}
