% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kostka.R
\name{KostkaNumbers}
\alias{KostkaNumbers}
\title{Kostka numbers for all partitions of a given weight}
\usage{
KostkaNumbers(n)
}
\arguments{
\item{n}{positive integer, the weight of the partitions}
}
\value{
An integer matrix, whose row names and column names encode the 
  partitions \eqn{\lambda} and \eqn{\mu} and whose entries are the 
  Kostka numbers \eqn{K(\lambda,\mu)}.
}
\description{
Computes the Kostka numbers for all integer partitions 
  of a given weight.
}
\examples{
KostkaNumbers(4)
}
\seealso{
\code{\link{KostkaNumbersWithGivenLambda}}, 
  \code{\link{KostkaNumbersWithGivenMu}}, \code{\link{skewKostkaNumbers}}.
}
