% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabgee.R
\name{tabgee}
\alias{tabgee}
\title{Create Summary Table for Fitted Generalized Estimating Equation Model}
\usage{
tabgee(
  fit,
  data = NULL,
  columns = NULL,
  robust = TRUE,
  var.labels = NULL,
  factor.compression = 1,
  sep.char = ", ",
  decimals = 2,
  formatp.list = NULL
)
}
\arguments{
\item{fit}{Fitted \code{\link[gee]{gee}} object.}

\item{data}{Data frame that served as 'data' in function call to
\code{\link[gee]{gee}}. Only needs to be specified if one or more of the
predictors is a factor and \code{factor.compression} is 1, 2, 3, or 4.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"beta"}, \code{"se"}, \code{"betaci"} for 95\% CI
for Beta, \code{"beta.se"} for Beta (SE), \code{"beta.ci"} for Beta
(95\% CI), \code{"or"}, \code{"orci"} for 95\% CI for OR, \code{"or.ci"} for
OR (95\% CI), \code{"hr"}, \code{"hrci"} for 95\% CI for HR, \code{"hr.ci"}
for HR (95\% CI), \code{"z"} for z statistic, and \code{"p"}. If OR's or HR's
are requested, the function will trust that exponentiated betas correspond to
these quantities.}

\item{robust}{Logical value for whether to use robust standard errors.}

\item{var.labels}{Named list specifying labels to use for certain predictors.
For example, if \code{fit} includes a predictor named "race"
that you want to label "Race/ethnicity" and a predictor named "age_yrs" that
you want to label "Age (years)", use
\code{var.labels = list(race = "Race/ethnicity", age_yrs = "Age (years)"}.}

\item{factor.compression}{Integer value from 1 to 5 controlling how much
compression is applied to factor predictors (higher value = more
compression). If 1, rows are Variable, Level 1 (ref), Level 2, ...; if 2,
rows are Variable (ref = Level 1), Level 2, ...; if 3, rows are Level 1
(ref), Level 2, ...; if 4, rows are Level 2 (ref = Level 1), ...; if 5, rows
are Level 2, ...}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}
}
\value{
\code{\link[knitr]{kable}}.
}
\description{
Creates a table summarizing a GEE fit using the \code{\link[gee]{gee}}
function.
}
\examples{
# Load in sample dataset and convert to long format
tabdata2 <- reshape(data = tabdata,
                    varying = c("bp.1", "bp.2", "bp.3", "highbp.1",
                                "highbp.2", "highbp.3"),
                    timevar = "bp.visit", direction = "long")
tabdata2 <- tabdata2[order(tabdata2$id), ]

# Blood pressure at 1, 2, and 3 months vs. age, sex, race, and treatment
library("gee")
fit <- gee(bp ~ Age + Sex + Race + Group, id = id, data = tabdata2,
           corstr = "unstructured")
tabgee(fit)

# Can also use piping
fit \%>\% tabgee(data = tabdata2)

# Same as previous, but with custom labels for Age and Race and factors
# displayed in slightly more compressed format
fit \%>\%
  tabgee(
    data = tabdata2,
    var.labels = list(Age = "Age (years)", Race = "Race/ethnicity"),
    factor.compression = 2
  )

# GEE with some higher-order terms
# higher-order terms
fit <- gee(
  highbp ~ poly(Age, 2, raw = TRUE) + Sex + Race + Group + Race*Group,
  id = id,
  data = tabdata2,
  family = "binomial",
  corstr = "unstructured"
)
fit \%>\% tabgee(data = tabdata2)


}
