% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_struct.R
\name{sens_struct}
\alias{sens_struct}
\title{Generate a sensor structure from a sensor data vector or matrix.}
\usage{
sens_struct(
  data,
  sampling_rate = NULL,
  times = NULL,
  depid,
  type,
  unit = NULL,
  frame = NULL,
  name = NULL,
  start_offset = 0,
  start_offset_units = "second",
  quiet = FALSE
)
}
\arguments{
\item{data}{sensor data vector or matrix}

\item{sampling_rate}{(optional) sensor data sampling rate in Hz}

\item{times}{(optional) is the time in seconds of each measurement in data for irregularly sampled data. The time reference (i.e., the 0 time) should be with respect to the start time of the deployment.}

\item{depid}{string that provides a unique identifier for this tag deployment}

\item{type}{is a string containing the first few letters of the sensor type,
e.g., acc for acceleration. These will be matched to the list of
sensor names in the sensor_names.csv file. If more than one sensor
matches type, a warning will be given. type can be in upper or lower case.}

\item{unit}{(optional) units in which data are sampled. Default determined by matching \code{type} with defaults in sensor_names.csv}

\item{frame}{(optional) frame of reference for data axes, for example 'animal' or 'tag'. Default determined by matching \code{type} with defaults in sensor_names.csv.}

\item{name}{(optional) "full name" to assign to the variable. Default determined by matching \code{type} to defaults in sensor_names.csv/}

\item{start_offset}{(optional) offset in start time for this sensor relative to start of tag recording. Defaults to 0.}

\item{start_offset_units}{(optional) units of start_offset. default is 'second'.}

\item{quiet}{prints to screen if quiet is set to false}
}
\value{
A sensor list with field \code{data} containing the data and with metadata fields pre-populated from the sensor_names.csv file. Change these manually as needed (or specify the relevant inputs to \code{sens_struct}) to the correct values.
}
\description{
Generate a sensor structure from a sensor data vector or matrix.
}
\examples{
HB <- harbor_seal
A <- sens_struct(data=HB$A$data,sampling_rate=3,depid='md13_134a', type='acc', quiet=TRUE)

}
