% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{cluster_frequency}
\alias{cluster_frequency}
\title{The Frequency of Assignment to Each Cluster}
\usage{
cluster_frequency(
  object,
  only = NULL,
  clusters = NULL,
  additional_data = NULL,
  ...
)
}
\arguments{
\item{object}{An object for which a summary is desired.}

\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data}.

The default \code{NULL} selects all clusterings in \code{object}.}

\item{clusters}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the cluster or clusters in \code{object} one wants to
see summaries of. Names can be used as if they were positions in the data
frame, so expressions like I:IV can be used to select a range of clusters.

The default \code{NULL} selects all clusters in the chosen clusterings of
\code{object}.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}

\item{...}{Additional arguments passed to the specific summary sub-function.}
}
\value{
\code{cluster_frequency()} returns a data frame with class
\code{cluster_frequency}.
\itemize{
\item \code{Clustering} the name of the clustering.
\item \code{Cluster} the cluster name.
\item \code{Count} the number of individuals assigned to the cluster.
\item \code{Percent} the percent of individuals assigned to the cluster.
}
}
\description{
The function \code{cluster_frequency()} calculates the number and frequency of
individuals assigned to each cluster.
}
\details{
\code{cluster_frequency()} calculates the number of individuals assigned to
each cluster and the associated frequency of assignment.
}
\examples{
clust <- medic(complications, id = id, atc = atc, k = 3:5)

# make frequency tables
cluster_frequency(clust, k == 5)
cluster_frequency(clust, k < 5, I:III)

}
