% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_qs.R
\name{tar_resources_qs}
\alias{tar_resources_qs}
\title{Target resources: qs storage formats}
\usage{
tar_resources_qs(
  compress_level = targets::tar_option_get("resources")$qs$compress_level,
  shuffle = targets::tar_option_get("resources")$qs$shuffle,
  nthreads = targets::tar_option_get("resources")$qs$nthreads,
  preset = NULL
)
}
\arguments{
\item{compress_level}{Positive integer, \code{compress_level} argument of
\code{\link[qs2:qs_save]{qs2::qs_save()}} to control the compression level.}

\item{shuffle}{\code{TRUE} to use byte shuffling in
\code{\link[qs2:qs_save]{qs2::qs_save()}} to improve compression at the cost of some
computation time, \code{FALSE} to forgo byte shuffling.}

\item{nthreads}{Positive integer, number of threads to use for
functions in the \code{qs2} package to save and read the data.}

\item{preset}{Deprecated in \code{targets} version 1.8.0.9014 (2024-11-11)
and not used.}
}
\value{
Object of class \code{"tar_resources_qs"}, to be supplied
to the qs argument of \code{tar_resources()}.
}
\description{
Create the \code{qs} argument of \code{tar_resources()}
to specify optional settings for big data storage formats
powered by the \code{qs} R package.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "qs",
  resources = tar_resources(
    qs = tar_resources_qs(preset = "fast")
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources}()},
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_crew}()},
\code{\link{tar_resources_custom_format}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_network}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_repository_cas}()},
\code{\link{tar_resources_url}()}
}
\concept{resources}
