% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_names.R
\name{get_names}
\alias{get_names}
\title{get_names}
\usage{
get_names(
  id,
  provider = getOption("taxadb_default_provider", "itis"),
  version = latest_version(),
  format = c("guess", "prefix", "bare", "uri"),
  taxadb_db = td_connect(),
  db = NULL
)
}
\arguments{
\item{id}{a list of taxonomic identifiers.}

\item{provider}{abbreviation code for the provider.  See details.}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  see \verb{[avialable_releases()]} for details.}

\item{format}{Format for the returned identifier, one of
\itemize{
\item \code{prefix} (e.g. \code{NCBI:9606}, the default), or
\item \code{bare} (e.g. \code{9606}, used in \code{taxize::get_ids()}),
\item \code{uri} (e.g.
\verb{http://ncbi.nlm.nih.gov/taxonomy/9606}).
}}

\item{taxadb_db}{Connection to from \verb{[td_connect()]}.}

\item{db}{previous name for \code{provider} argument, now deprecated}
}
\value{
a vector of names, of the same length as the input ids. Any
unmatched IDs will return as \link{NA}s.
}
\description{
Translate identifiers into scientific names
}
\details{
Like all taxadb functions, this function will run
fastest if a local copy of the provider is installed in advance
using \verb{[td_create()]}.
}
\examples{
\donttest{

\dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME = file.path(tempdir(), "taxadb"))
   options("taxadb_default_provider"="itis_test")
  }

get_names(c("ITIS:1025094", "ITIS:1025103"), format = "prefix")

}

}
\seealso{
Other get: 
\code{\link{get_ids}()}
}
\concept{get}
