% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_tbl.R
\name{taxa_tbl}
\alias{taxa_tbl}
\title{Return a reference to a given table in the taxadb database}
\usage{
taxa_tbl(
  provider = getOption("taxadb_default_provider", "itis"),
  schema = c("dwc", "common"),
  version = latest_version(),
  db = td_connect()
)
}
\arguments{
\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{schema}{One of "dwc" (for Darwin Core data) or "common"
(for the Common names table.)}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{tl_import} for details.}

\item{db}{a connection to the taxadb database. See details.}
}
\description{
Return a reference to a given table in the taxadb database
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME=file.path(tempdir(), "taxadb"))
   options("taxadb_default_provider"="itis_test")
  }

  ## default schema is the dwc table
  taxa_tbl()

  ## common names table
  taxa_tbl(schema = "common")



}
}
