% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tn_aun.R
\name{tn_aun}
\alias{tn_aun}
\alias{tn_fun}
\alias{tn_funa}
\alias{tn_auna}
\title{Standard formats for taxonomic names}
\usage{
tn_fun(x, ...)

tn_funa(x, ...)

tn_aun(x, ...)

tn_auna(x, ...)
}
\arguments{
\item{x}{A vector containing selected identifiers for taxon names
(\strong{TaxonUsageID}) included in the internal taxonomic object
(see \code{\link[=set_tax]{set_tax()}}).}

\item{...}{Further arguments passed to \code{\link[taxlist:print_name]{taxlist::print_name()}}.}
}
\value{
All these functions return a character value.
}
\description{
These functions work similarly to \code{\link[=tn_an]{tn_an()}} and its alies but the names
are accessed by their \strong{TaxonUsageID} and work also for synonyms.

Suffixes in the function names are explained as follows:
\itemize{
\item \strong{fun:} Full usage name without author name.
\item \strong{funa:} Full usage name with author name.
\item \strong{aun:} Abbreviated usage name without author name.
\item \strong{auna:} Abbreviated usage name with author name.
}
}
\examples{
## Compare all these outputs
tn_fun(52613)
tn_funa(52613)
tn_aun(52613)
tn_auna(52613)
}
