% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_average_traffic.R
\name{gg_traffic_avg}
\alias{gg_traffic_avg}
\title{Average of traffic during a week.}
\usage{
gg_traffic_avg(
  enriched_data,
  date_range = NULL,
  segments = NULL,
  modes = c("heavy", "car"),
  direction = "both",
  weekday = NULL,
  aggregated_by = "weekday"
)
}
\arguments{
\item{enriched_data}{enriched data.frame containing all the data for all your sensors}

\item{date_range}{Date vector. example: c('2021-01-01','2022-01-01'). Full period if NULL (default).}

\item{segments}{Character vector. Selected road segment, all if NULL (default).}

\item{modes}{Character vector. Different modes of transportation aggregated (heavy, car, bike, pedestrian) . Default: heavy & car}

\item{direction}{Character. Direction of the traffic (lft, rgt, both). Default to both.}

\item{weekday}{Character vector. Weekday choosen. Default to the all week.}

\item{aggregated_by}{Character. Options are: 'segment_name', 'weekday', 'direction', 'mode'. Default: 'weekday'.}
}
\value{
Graph showing weekly average evolution of traffic (for specified parameters) during the specified period.
}
\description{
A short description...
Average of traffic during a week, over a period for a segment or a subset of segment,
for a transportation mode or more, for a direction or both.
}
\examples{
gg_traffic_avg(traffic)
gg_traffic_avg(traffic,
  date_range = c('2022-07-01','2022-09-01'),
  segment = 'RteVitre-06',
  mode = 'car',
  direction = 'rgt',
  weekday = c('monday','friday')
  )
}
