% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cells2samp.R
\name{cells2samp}
\alias{cells2samp}
\title{Helper function to randomly select cell IDs for generating
environmental background data.}
\usage{
cells2samp(
  data,
  longitude,
  latitude,
  cell_ids = NULL,
  buffer_ngbs = 2,
  raster_mask,
  process_ngbs_by = 10,
  n_bg = 50000,
  progress = TRUE
)
}
\arguments{
\item{data}{A data.frame containing longitude and latitude data of occurrence
points.}

\item{longitude}{A character vector specifying the column name of longitude
in 'data'.}

\item{latitude}{A character vector specifying the column name of latitude
in 'data'.}

\item{cell_ids}{A numeric vector indicating the IDs of cells that serve as
geographic centers for buffers. Default is NULL.}

\item{buffer_ngbs}{Number of neighboring pixels around occurrence points
used to build the buffer for sampling.}

\item{raster_mask}{An object of class SpatRaster used to obtain pixel IDs.}

\item{process_ngbs_by}{Numeric parameter to improve memory management.
It process neighbor cells by a quantity specified by the user.}

\item{n_bg}{Number of background pixels to sample.}

\item{progress}{Logical. If \code{TRUE}, show computation progress.}
}
\value{
A numeric vector of cell IDs to be sampled for environmental
background data.
}
\description{
This function returns pixel IDs to be sampled for generating environmental
background data around species occurrence points.
}
\examples{
\donttest{
# cells to sample
data(abronia)
temporal_layer <- system.file("extdata/bio/2016/bio_01.tif",package = "tenm")
raster_mask <- terra::rast(temporal_layer)
set.seed(123)
samp_01 <- tenm::cells2samp(data = abronia,
                            longitude = "decimalLongitude",
                            latitude = "decimalLatitude",
                            cell_ids = NULL,
                            buffer_ngbs = 4,
                            raster_mask = raster_mask,
                            process_ngbs_by = 10,
                            n_bg = 50000,
                            progress =TRUE)
# Generete a sample using pixel IDs
samp_02 <- tenm::cells2samp(data = abronia,
                            longitude = NULL,
                            latitude = NULL,
                            cell_ids = c(256,290,326),
                            buffer_ngbs = 4,
                            raster_mask = raster_mask,
                            process_ngbs_by = 10,
                            n_bg = 50000,
                            progress =TRUE)
}

}
