% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diagnostics.R
\name{plot_diagnostics}
\alias{plot_diagnostics}
\title{Visualise diagnostics across the tested arguments}
\usage{
plot_diagnostics(
  object,
  focused_args = NULL,
  average_out_non_focused_args = TRUE,
  plot_order = NULL
)
}
\arguments{
\item{object}{an object of class \code{'testargs'}}

\item{focused_args}{the arguments we wish to plot. If \code{NULL}, all
arguments are plotted (i.e., \code{focused_args = object@arg_names})}

\item{average_out_non_focused_args}{logical indicating whether we should
average over the non-focused arguments}

\item{plot_order}{specifies the order in which we are to assign
arguments to the various aesthetics. If \code{NULL}, the
arguments are assigned based on their \code{type}, in the order \code{'numeric'},
\code{'integer'}, \code{'factor'}, \code{'character'}, and \code{'logical'}.
Otherwise, \code{plot_order} should be an integer vector with the same length
as \code{focused_args}}
}
\value{
a facetted \code{'ggplot'} object, where:
\itemize{
\item{the columns of the facet are split by the diagnostics}
\item{the y-axis corresponds to the values of the diagnostics}
\item{the x-axis corresponds to the first argument}
\item{the colour scale and grouping correspond to the second argument (if present)}
\item{if a third argument is present, \code{facet_grid()} is used, whereby columns correspond to levels of the third argument, and rows correspond to diagnostics. Note that \code{facet_grid()} forces a given row to share a common y-scale, so the plot would be misleading if diagnostics were kept as columns}
\item{the shape of the points corresponds to the fourth argument (if present)}
}
}
\description{
Using various aesthetics, \code{plot_diagnostics()} can visualise the
performance of all combinations of up to 4 different arguments simultaneously.
}
\examples{
## See ?test_arguments
}
