% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testcorr.R
\name{ac.test}
\alias{ac.test}
\title{Testing zero autocorrelation}
\usage{
ac.test(x, max.lag, m0 = 1, alpha = 0.05, lambda = 2.576,
        plot = TRUE, var.name = NULL, scale.font = 1)
}
\arguments{
\item{x}{A numeric vector or a univariate numeric time series (ts, xts, zoo) object or a data frame variable.}

\item{max.lag}{Maximum lag at which to calculate the test statistics.}

\item{m0}{Minimum lag at which to calculate the cumulative test statistics. Default is 1.}

\item{alpha}{Significance level for hypothesis testing used in the plots. Default is 0.05.}

\item{lambda}{Threshold in \eqn{\widetilde{Q}}{Q-tilde} test statistics. Default is 2.576.}

\item{plot}{Logical. If TRUE, 1) the sample autocorrelations with their confidence bands are plotted and 2) the cumulative test statistics with their critical values are plotted. Default is TRUE. Can be a logical vector for each of the plots 1)-2).}

\item{var.name}{NULL or a character string specifying the variable name. If NULL and x has name, the name of x is used. If NULL and x has no name, the string "x" is used. Default is NULL.}

\item{scale.font}{A positive number indicating the scaling of the font size in the plots. Default is 1.}
}
\value{
An object of class "ac.test", which is a list with the following components:
\item{lag}{The lags of the sample autocorrelations.}
\item{ac}{The sample autocorrelations.}
\item{scb}{The lower and upper limit of the confidence bands based on the standard test statistics.}
\item{rcb}{The lower and upper limit of the confidence bands based on the robust test statistics.}
\item{t}{The \eqn{t}{t} test statistics.}
\item{pvt}{The p-values for the \eqn{t}{t} test statistics.}
\item{ttilde}{The \eqn{\widetilde{t}}{t-tilde} test statistics.}
\item{pvttilde}{The p-values for the \eqn{\widetilde{t}}{t-tilde} test statistics.}
\item{lagc}{The lags of the cumulative test statistics.}
\item{lb}{The \eqn{LB} test statistics.}
\item{pvlb}{The p-values for the \eqn{LB} test statistics.}
\item{qtilde}{The \eqn{\widetilde{Q}}{Q-tilde} test statistics.}
\item{pvqtilde}{The p-values for the \eqn{\widetilde{Q}}{Q-tilde} test statistics.}
\item{alpha}{Significance level for hypothesis testing used in the plots.}
\item{varname}{The variable name used in the plots/table.}
}
\description{
The function ac.test computes the test statistics for examining the null hypothesis
of zero autocorrelation for univariate time series given in Dalla, Giraitis and Phillips (2022).
}
\details{
The standard \eqn{t} and robust \eqn{\widetilde{t}}{t-tilde} statistics are for testing the null hypothesis \eqn{H_0:\rho_k=0}{H[0]:\rho[k]=0} at lags \eqn{k=1,...,max.lag},
and the standard \eqn{LB} and robust \eqn{\widetilde{Q}}{Q-tilde} statistics are for testing the null hypothesis \eqn{H_0:\rho_{m_0}=...=\rho_m=0}{H[0]:\rho[m0]=...=\rho[m]=0} at lags \eqn{m=m_0,...,max.lag}{m=m0,...,max.lag},
where \eqn{\rho_k}{\rho[k]} denotes the autocorrelation of \eqn{x_t}{x[t]} at lag \eqn{k}.
}
\note{
Missing values are not allowed.
}
\examples{
x <- rnorm(100)
ac.test(x, max.lag = 10)
}
\references{
Dalla, V., Giraitis, L. and Phillips, P. C. B. (2022). "Robust Tests for White Noise and Cross-Correlation". Econometric Theory, 38(5), 913-941, \doi{doi:10.1017/S0266466620000341}. Cowles Foundation, Discussion Paper No. 2194RS, \url{https://elischolar.library.yale.edu/cowles-discussion-paper-series/57/}. \cr
Giraitis, L., Li, Y. and Phillips, P. C. B. (2024). "Robust Inference on Correlation under General Heterogeneity". Journal of Econometrics, 244(1), 105691, \doi{doi:10.1016/j.jeconom.2024.105691}.
}
\author{
Violetta Dalla, Liudas Giraitis and Peter C. B. Phillips
}
