% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfb-spline.R
\name{tfb_spline}
\alias{tfb_spline}
\alias{tfb_spline.data.frame}
\alias{tfb_spline.matrix}
\alias{tfb_spline.numeric}
\alias{tfb_spline.list}
\alias{tfb_spline.tfd}
\alias{tfb_spline.tfb}
\alias{tfb_spline.default}
\title{Spline-based representation of functional data}
\usage{
tfb_spline(data, ...)

\method{tfb_spline}{data.frame}(
  data,
  id = 1,
  arg = 2,
  value = 3,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)

\method{tfb_spline}{matrix}(
  data,
  arg = NULL,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)

\method{tfb_spline}{numeric}(
  data,
  arg = NULL,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)

\method{tfb_spline}{list}(
  data,
  arg = NULL,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)

\method{tfb_spline}{tfd}(
  data,
  arg = NULL,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)

\method{tfb_spline}{tfb}(
  data,
  arg = NULL,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)

\method{tfb_spline}{default}(
  data,
  arg = NULL,
  domain = NULL,
  penalized = TRUE,
  global = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{a \code{matrix}, \code{data.frame} or \code{list} of suitable shape, or another
\code{tf}-object containing functional data.}

\item{...}{arguments to the calls to \code{\link[mgcv:s]{mgcv::s()}} setting up the basis (and
to \code{\link[mgcv:magic]{mgcv::magic()}} or \code{\link[mgcv:gam.fit]{mgcv::gam.fit()}} if \code{penalized = TRUE}). Uses \code{k = 25} cubic regression spline basis functions (\code{bs = "cr"}) by default, but
should be set appropriately by the user. See Details and examples in the
vignettes.}

\item{id}{The name or number of the column defining which data belong to
which function.}

\item{arg}{\code{numeric}, or list of \code{numeric}s. The evaluation grid.
For the \code{data.frame}-method: the
name/number of the column defining the evaluation grid. The \code{matrix} method
will try to guess suitable \code{arg}-values from the column names of \code{data} if
\code{arg} is not supplied. Other methods fall back on integer sequences
(\verb{1:<length of data>}) as the default if not provided.}

\item{value}{The name or number of the column containing the function
evaluations.}

\item{domain}{range of the \code{arg}.}

\item{penalized}{\code{TRUE} (default) estimates regularized/penalized basis
coefficients via \code{\link[mgcv:magic]{mgcv::magic()}} or \code{\link[mgcv:gam.fit]{mgcv::gam.fit()}}, \code{FALSE} yields
ordinary least squares / ML estimates for basis coefficients. \code{FALSE} is
much faster but will overfit for noisy data if \code{k} is (too) large.}

\item{global}{Defaults to \code{FALSE}. If \code{TRUE} and \code{penalized = TRUE}, all
functions share the same smoothing parameter (see Details).}

\item{verbose}{\code{TRUE} (default) outputs statistics about the fit achieved by
the basis and other diagnostic messages.}
}
\value{
a \code{tfb}-object
}
\description{
Represent curves as a weighted sum of spline basis functions.
}
\details{
The basis to be used is set up via a call to \code{\link[mgcv:s]{mgcv::s()}} and all the spline
bases discussed in \code{\link[mgcv:smooth.terms]{mgcv::smooth.terms()}} are available, in principle.
Depending on the value of the \code{penalized}- and \code{global}-flags, the
coefficient vectors for each observation are then estimated via fitting a GAM
(separately for each observation, if \code{!global}) via \code{\link[mgcv:magic]{mgcv::magic()}} (least
square error, the default) or \code{\link[mgcv:gam]{mgcv::gam()}} (if a \code{family} argument was
supplied) or unpenalized least squares / maximum likelihood.

After the "smoothed" representation is computed, the amount of smoothing that
was performed is reported in terms of the "percentage of variability
preserved", which is the variance (or the explained deviance, in the general
case if \code{family} was specified) of the smoothed function values divided by the variance of the original
values (the null deviance, in the general case). Reporting can be switched off
with \code{verbose = FALSE}.

The \code{...} arguments supplies arguments to both the
spline basis (via \code{\link[mgcv:s]{mgcv::s()}}) and the estimation (via
\code{\link[mgcv:magic]{mgcv::magic()}} or \code{\link[mgcv:gam]{mgcv::gam()}}), the most important arguments are:
\itemize{
\item \strong{\code{k}}: how many basis functions should the spline basis use, default is 25.
\item \strong{\code{bs}}: which type of spline basis should be used, the default is cubic
regression splines (\code{bs = "cr"})
\item \strong{\code{family}} argument: use this if minimizing squared errors is not
a reasonable criterion for the representation accuracy (see
\code{\link[mgcv:family.mgcv]{mgcv::family.mgcv()}} for what's available) and/or if function values are
restricted to be e.g. positive (\code{family = Gamma()/tw()/...}), in
\eqn{[0,1]}  (\code{family = betar()}), etc.
\item \strong{\code{sp}}: numeric value for the smoothness penalty weight, for manually
setting the amount of smoothing for all curves, see \code{\link[mgcv:s]{mgcv::s()}}. This
(drastically) reduces computation time. Defaults to \code{-1}, i.e., automatic
optimization of \code{sp} using \code{\link[mgcv:magic]{mgcv::magic()}} (LS fits) or \code{\link[mgcv:gam]{mgcv::gam()}} (GLM),
source code in \code{R/tfb-spline-utils.R}.
}

If \strong{\code{global == TRUE}}, this uses a small subset of curves (10\verb{\%} of curves,
at least 5, at most 100; non-random sample using every j-th curve in the
data) on which smoothing parameters per curve are estimated and then takes
the mean of the log smoothing parameter of those as \code{sp} for all curves. This
is much faster than optimizing for each curve on large data sets. For very
sparse or noisy curves, estimating a common smoothing parameter based on the
data for all curves simultaneously is likely to yield better results, this is
\emph{not} what's implemented here.
}
\section{Methods (by class)}{
\itemize{
\item \code{tfb_spline(data.frame)}: convert data frames

\item \code{tfb_spline(matrix)}: convert matrices

\item \code{tfb_spline(numeric)}: convert matrices

\item \code{tfb_spline(list)}: convert lists

\item \code{tfb_spline(tfd)}: convert \code{tfd} (raw functional data)

\item \code{tfb_spline(tfb)}: convert \code{tfb}: modify basis representation, smoothing.

\item \code{tfb_spline(default)}: convert \code{tfb}: default method, returning prototype
when data is missing

}}
\seealso{
\code{\link[mgcv:smooth.terms]{mgcv::smooth.terms()}} for spline basis options.

Other tfb-class: 
\code{\link{fpc_wsvd}()},
\code{\link{tfb}},
\code{\link{tfb_fpc}()}
}
\concept{tfb-class}
\concept{tfb_spline-class}
