% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{autocov2MA}
\alias{autocov2MA}
\title{Convert autocovariances to MA parameters}
\usage{
autocov2MA(x, method = c("roots", "acov"), tol = 1e-05)
}
\arguments{
\item{x}{Numeric vector of autocovariances (length q).}

\item{method}{Estimation method: "roots" (Godolphin 1976) or "acov" (Wilson
1969). Default is "roots".}

\item{tol}{Tolerance for zero autocovariance. Default 1e-5.}
}
\value{
Named vector: c(s2, ma0=1, ma1=-theta1, ..., maq=-thetaq).
}
\description{
Computes MA polynomial coefficients and error variance from autocovariances.
}
\examples{
ma1 <- um(ma = "1 - 0.8B", sig2 = 0.5)
autocov2MA(autocov(ma1, 1))
autocov2MA(autocov(ma1, 1), method = "acov")
}
\references{
Godolphin, E. J. (1976). On the Cramer-Wold factorization.
\emph{Biometrika}, \strong{63}(2), 367-372. \doi{10.1093/biomet/63.2.367}

Tunnicliffe Wilson, G. (1969). Factorization of the covariance generating
function of a pure moving average process. \emph{SIAM Journal on Numerical
Analysis}, \strong{6}(1), 1-7. \doi{10.1137/0706001}
}
