% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrow_dataset.R
\name{arrow_feather_dataset}
\alias{arrow_feather_dataset}
\title{Creates a \code{ArrowFeatherDataset}.}
\usage{
arrow_feather_dataset(filenames, columns, output_types, output_shapes = NULL)
}
\arguments{
\item{filenames}{A \code{tf.string} tensor, list or scalar containing files in
Arrow Feather format.}

\item{columns}{A list of column indices to be used in the Dataset.}

\item{output_types}{Tensor dtypes of the output tensors.}

\item{output_shapes}{TensorShapes of the output tensors or \code{NULL} to infer
partial.}
}
\description{
An Arrow Dataset for reading record batches from Arrow feather files. Feather
is a light-weight columnar format ideal for simple writing of Pandas
DataFrames.
}
\examples{
\dontrun{
dataset <- arrow_feather_dataset(
    list('/path/to/a.feather', '/path/to/b.feather'),
    columns = reticulate::tuple(0L, 1L),
    output_types = reticulate::tuple(tf$int32, tf$float32),
    output_shapes = reticulate::tuple(list(), list())) \%>\%
  dataset_repeat(1)

sess <- tf$Session()
iterator <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iterator)

until_out_of_range({
  batch <- sess$run(next_batch)
  print(batch)
})
}

}
