% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-sse.R
\name{sse_within}
\alias{sse_within}
\title{Calculates Sum of Squared Error in each cluster}
\usage{
sse_within(
  object,
  new_data = NULL,
  dist_fun = function(x, y) {
     philentropy::dist_many_many(x, y, method =
    "euclidean")
 }
)
}
\arguments{
\item{object}{A fitted kmeans tidyclust model}

\item{new_data}{A dataset to predict on.  If \code{NULL}, uses trained clustering.}

\item{dist_fun}{A function for calculating distances to centroids.  Defaults
to Euclidean distance on processed data.}
}
\value{
A tibble with two columns, the cluster name and the SSE within that
cluster.
}
\description{
Calculates Sum of Squared Error in each cluster
}
\details{
\code{\link[=sse_within_total]{sse_within_total()}} is the corresponding cluster metric function
that returns the sum of the values given by \code{sse_within()}.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

sse_within(kmeans_fit)
}
