% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_osap.R
\name{download_data_osap}
\alias{download_data_osap}
\title{Download and Process Open Source Asset Pricing Data}
\usage{
download_data_osap(
  start_date = NULL,
  end_date = NULL,
  sheet_id = "1JyhcF5PRKHcputlioxlu5j5GyLo4JYyY"
)
}
\arguments{
\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, the full dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, the full dataset is returned.}

\item{sheet_id}{A character string representing the Google Sheet ID from which to download the data.
Default is \code{"1JyhcF5PRKHcputlioxlu5j5GyLo4JYyY"}.}
}
\value{
A tibble containing the processed data. The column names are converted to snake_case,
and the data is filtered by the specified date range if \code{start_date} and \code{end_date} are provided.
}
\description{
This function downloads the data from \href{https://www.openassetpricing.com/data/}{Open Source Asset Pricing}
from Google Sheets using a specified sheet ID, processes the data by converting column names to
snake_case, and optionally filters the data based on a provided date range.
}
\examples{
\donttest{
  osap_monthly <- download_data_osap(start_date = "2020-01-01", end_date = "2020-06-30")
}
}
