% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_casters.R
\name{cast_sparse}
\alias{cast_sparse}
\title{Create a sparse matrix from row names, column names, and values
in a table.}
\usage{
cast_sparse(data, row, column, value, ...)
}
\arguments{
\item{data}{A tbl}

\item{row}{Column name to use as row names in sparse matrix, as string or symbol}

\item{column}{Column name to use as column names in sparse matrix, as string or symbol}

\item{value}{Column name to use as sparse matrix values (default 1) as string or symbol}

\item{...}{Extra arguments to pass on to \code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix()}}}
}
\value{
A sparse Matrix object, with one row for each unique value in
the \code{row} column, one column for each unique value in the \code{column}
column, and with as many non-zero values as there are rows in \code{data}.
}
\description{
This function supports non-standard evaluation through the tidyeval framework.
}
\details{
Note that cast_sparse ignores groups in a grouped tbl_df. The arguments
\code{row}, \code{column}, and \code{value} are passed by expression and support
\link[rlang:topic-inject]{quasiquotation}; you can unquote strings and symbols.
}
\examples{

dat <- data.frame(a = c("row1", "row1", "row2", "row2", "row2"),
                  b = c("col1", "col2", "col1", "col3", "col4"),
                  val = 1:5)

cast_sparse(dat, a, b)

cast_sparse(dat, a, b, val)

}
