% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{tribal_subdivisions_national}
\alias{tribal_subdivisions_national}
\title{Download an American Indian Tribal Subdivision National shapefile into R.}
\usage{
tribal_subdivisions_national(cb = FALSE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2024}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Definition from the US Census Bureau: "American Indian Tribal Subdivisions (AITS) are legally defined
administrative subdivisions of federally
recognized American Indian reservations and/or off-reservation trust lands or Oklahoma tribal statistical
areas (OTSAs)."  For more information, please see the link provided.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
\item \code{protocol} Character string specifying the protocol to use for downloading files. Options are "ftp" or "http" (default). If "ftp", the URL will be modified to use FTP instead of HTTPS.
\item \code{timeout} Integer specifying the timeout in seconds for download operations if protocol is "ftp". Defaults to 1800 (30 minutes) to handle large files.
}
}

\examples{
\dontrun{
library(tigris)
library(leaflet)

trib <- tribal_subdivisions_national()
leaflet(trib) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5)
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch5GARM.pdf}

Other native/tribal geometries functions: 
\code{\link{alaska_native_regional_corporations}()},
\code{\link{native_areas}()},
\code{\link{tribal_block_groups}()},
\code{\link{tribal_census_tracts}()}
}
\concept{native/tribal geometries functions}
