% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_levels.R
\name{db_access_level_create}
\alias{db_access_level_create}
\title{Create a New Role (Access Level)}
\usage{
db_access_level_create(
  con,
  access_level_name,
  access_level_description = NULL,
  access_level_default = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{access_level_name}{\strong{character} name of the access level to insert.}

\item{access_level_description}{\strong{character} description of the access level. Defaults to NA.}

\item{access_level_default}{set if the new access level should be the default. Defaults to NA.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
returns a list containing the parsed JSON status feedback from the DB.
}
\description{
Creates a new role in the database. Roles represent access levels and together
with the assignment of roles to time series, versions of time series or datasets
define who is allowed to access a particular series.
}
\seealso{
Other access levels functions: 
\code{\link{change_access_level}},
\code{\link{db_access_level_delete}()},
\code{\link{db_access_level_list}()},
\code{\link{db_access_level_set_default}()},
\code{\link{db_ts_find_keys}()}
}
\concept{access levels functions}
