% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{db_call_function}
\alias{db_call_function}
\title{Helper to construct SQL function calls}
\usage{
db_call_function(con, fname, args = NULL, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{fname}{character Name of the function to be called}

\item{args}{list of function arguments. A single, unnested list.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
value of `dbGetQuery(con, "SELECT * FROM schema.fname($args)")$fname`
}
\description{
Calls function `schema`.`fname` with the given `args`, returning
the result.
}
\details{
Args may be named to enable postgres to decide which candidate to choose in case
of overloaded functions.
If any args are named, all of them must be.
}
