% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{db_metadata_read}
\alias{db_metadata_read}
\title{Read Time Series Metadata}
\usage{
db_metadata_read(
  con,
  ts_keys,
  valid_on = NULL,
  regex = FALSE,
  locale = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{valid_on}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. valid_on selects the
version of a time series that is valid at the specified time.}

\item{regex}{\strong{boolean} indicating if ts_keys should be interpreted as a regular expression pattern. Defaults to FALSE.}

\item{locale}{\strong{character} indicating the language of the meta information to be store. We recommend to use ISO country codes to represent languages. Defaults to NULL. When local is set to NULL, metadata are stored without localization. Note that, when localizing meta information by assigning a language, multiple meta information objects can be stored for a single time series.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
list of tsmeta objects.
}
\description{
Read meta information given a vector of time series identifiers.
}
\seealso{
Other metadata functions: 
\code{\link{db_collection_read_metadata}()},
\code{\link{db_dataset_read_metadata}()},
\code{\link{db_meta_get_latest_validity}()},
\code{\link{db_metadata_store}()}
}
\concept{metadata functions}
