% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{db_metadata_store}
\alias{db_metadata_store}
\title{Store Time Series Metadata to PostgreSQL}
\usage{
db_metadata_store(
  con,
  metadata,
  valid_from,
  locale = NULL,
  on_conflict = "update",
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{metadata}{object of class tsmeta that contains the metadata to be stored.}

\item{valid_from}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. It should always be explicitly specified.}

\item{locale}{\strong{character} indicating the language of the meta information to be store. We recommend to use ISO country codes to represent languages. Defaults to NULL. When local is set to NULL, metadata are stored without localization. Note that, when localizing meta information by assigning a language, multiple meta information objects can be stored for a single time series.}

\item{on_conflict}{\strong{character} either "update": add new fields and update existing ones or "overwrite": completely replace existing record.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
status list created from DB status return JSON.
}
\description{
The most basic way to store meta information is to assign non-translated (unlocalized) descriptions, but it also can be stored in different languages (localized) using the parameter \strong{locale}. See also \href{https://mbannert.github.io/timeseriesdb/articles/a01_basic_usage.html#basic-metadata}{basic usage}.
}
\examples{

\dontrun{
sum("a")
}
}
\seealso{
Other metadata functions: 
\code{\link{db_collection_read_metadata}()},
\code{\link{db_dataset_read_metadata}()},
\code{\link{db_meta_get_latest_validity}()},
\code{\link{db_metadata_read}()}
}
\concept{metadata functions}
